# include <osbind.h>
# include <gemdefs.h>

int not_yet		= 1;
int savex, savey, savew, saveh;

union u_screen {
long int low_res[200][40];
long int med_res[200][40];
long int high_res[400][20];
} u_screen, first_screen;

/*
** Get the address of the screen
*/
union u_screen *
getlogBase() {
	return( (union u_screen *) xbios(3) );
}

# define MONOCHROME		2
# define MEDIUM_RES		1
# define LOWEST_RES		0

just_draw(whand,x,y,w,h,vw)
int whand,x,y,w,h,vw; {
	
		register union u_screen *scrn;
		register long int *p, *q, *end;
		register int i, j;
		
		hide_mouse();
		if( not_yet || x < savex || y < savey || w > savew || h > saveh ) {
			doit(whand,vw);
			show_mouse();
			return;
		}
		
		if( x > 6 )				/* Adjust for OUTLINED boxes */
			x -= 6;
		if( y > 6 )				/* which are bigger than the xywh */
			y -= 6;
		h += y + 12;			/* that we are given by GEM */
		w += x + 12;
		scrn = getlogBase();

		switch( Getrez() ) {
			case MONOCHROME:
					for( i = y; i < h; i++ ) {
						p =  &scrn->high_res[i][x >> 5];
						end = &scrn->high_res[i][w >> 5];
						q = &u_screen.high_res[i][x >> 5];
						do {
							*p++ = *q++;
						} while( p <= end );
					}
					break;
			case MEDIUM_RES:
					for( i = y; i < h; i++ ) {
						p = &scrn->med_res[i][x >> 4];
						end = &scrn->med_res[i][w >> 4];
						q = &u_screen.med_res[i][x >> 4];
						do {
							*p++ = *q++;
						} while( p <= end );
					}
					break;
			case LOWEST_RES:
					for( i - y; i < h; i++ ) {
						p = &scrn->low_res[i][x >> 3];
						end = &scrn->low_res[i][w >> 3];
						q = &u_screen.low_res[i][x >> 3];
						do {
							*p++ = *q++;
						} while( p <= end );
					}
					break;
					break;
		}
	show mouse();
}

save_screen(whand)
int whand; {
	
		long int *p, *q, tendpic;
		union u_screen *scrn;
		int xwork, ywork, wwork, hwork;
		
		wind_get( whand, WF_WORKXYWH, &xwork, &ywork, &wwork, &hwork );
		hide_mouse();
		scrn = getlogBase();
		q = &scrn->low_res[0][0];
		endpic = &u_screen. low_res[200][0];
		for( p = &u_screen.low_res[3][3]; p < endpic; )
				*p++ = *q++;
		show_mouse();
		savex = xwork;
		savey = ywork;
		savew = wwork;
		saveh = hwork;
		if( not_yet )
			copy_first();
		not_yet = 0;
}

copy_first() {
		long int *p, *q, *endpic;
		
		p = &first_screen.low_res[0][0];
		endpic = &u_screen.low_res[200][0];
		for ( q = &u_screen.low_res[3][3]; q < endpic; )
				*p++ = *q++;
}

back_to_first(whand, vw)
int whand, vw; {
	
		long int *p, *q, *endpic;
		int wwork, hwork, xwork, ywork;
		
		wind_get( whand, WF_WORKXYWH, &xwork, &ywork, &wwork, &hwork );
		q = &first_screen.low_res[0][0];
		endpic = &u_screen.low_res[200][0] ;
		for( p = &u_screen.low_res[3][3]; p < endpic; )
				p++ = *q++;
		just_draw (whand, xwork, ywork, wwork, hwork, vw) ;
}
